SetErrorMode(0)
#include"Include\Common.agc":InitCommonGlobals()
#include"Include\Map.agc"
#include"Include\Lighting.agc"
#include"Include\Sky.agc"
#include"Include\Lighting\Objects.agc"
#include"Include\Lighting\Effects.agc"
#include"Include\Lighting\Lights.agc"
#include"Include\Lighting\Shadows.agc"

   `Setup Main Window
      SetWindowSize(GetDevicewidth(),GetDeviceHeight(),1)
      SetWindowTitle("Tile Rendering")
      SetWindowAllowResize(0)
      SetRawMouseVisible(0)

   `Setup Display
      SetVirtualResolution(GetDevicewidth(),GetDeviceHeight())
      SetSyncrate(0,0)
      SetVSync(1)
      sw#=GetVirtualWidth()
      sh#=GetVirtualHeight()

   `Main Camera
      MainCamera=CreateCamera()
      CurrentCamera(MainCamera)
      RotateCamera(MainCamera,30,0,0)
      ColorBackdrop(MainCamera,0,0,0)
      MouseMoveReset()

   `Setup Lighting
      LightingSetUp() 
      ShadowsQuality(1)
      EnableSSAO(1)

   `Camera      
      LightingSetCamera(MainCamera,1,128000,125,sw#/sh#)
      FogSetColor(100,110,125,32000)

   `Effects
      ObjectEffect=CreateEffect()
      LoadEffectTechnique(ObjectEffect,"Lighting","Shaders\Surface\Lighting\Object.vs","Shaders\Surface\Lighting\Object.ps")
      LoadEffectTechnique(ObjectEffect,"Depth","Shaders\Surface\Depth\Depth.vs","Shaders\Surface\Depth\Depth.ps")
      ObjectLightingEffect=AddEffect(ObjectEffect)
      SkinnedMeshEffect=CreateEffect()
      LoadEffectTechnique(SkinnedMeshEffect,"Lighting","Shaders\Surface\Lighting\Skinned Mesh.vs","Shaders\Surface\Lighting\Skinned Mesh.ps")
      LoadEffectTechnique(SkinnedMeshEffect,"Depth","Shaders\Surface\Depth\Depth Skinned Mesh.vs","Shaders\Surface\Depth\Depth.ps")
      SkinnedMeshLightingEffect=AddEffect(SkinnedMeshEffect)
      AlphaEffect=CreateEffect()
      LoadEffectTechnique(AlphaEffect,"Lighting","Shaders\Surface\Lighting\Alpha.vs","Shaders\Surface\Lighting\Alpha.ps")
      AlphaLightingEffect=AddEffect(AlphaEffect)
      TreeEffect=CreateEffect()
      LoadEffectTechnique(TreeEffect,"Lighting","Shaders\Surface\Lighting\Tree.vs","Shaders\Surface\Lighting\Tree.ps")
      LoadEffectTechnique(TreeEffect,"Depth","Shaders\Surface\Depth\Depth Tree.vs","Shaders\Surface\Depth\Depth.ps")
      TreeLightingEffect=AddEffect(TreeEffect) 
      LeafEffect=CreateEffect()
      LoadEffectTechnique(LeafEffect,"Lighting","Shaders\Surface\Lighting\Tree.vs","Shaders\Surface\Lighting\Leaf.ps")
      LoadEffectTechnique(LeafEffect,"Depth","Shaders\Surface\Depth\Depth Tree.vs","Shaders\Surface\Depth\Depth Discard.ps")
      LeafLightingEffect=AddEffect(LeafEffect)

   `Test Map
      LoadTexture(50,"Resources\refl.png")
      LoadObject(1,"Resources\Map.x")
      ApplyTexture(1,"Resources\")
      SetObjectEffect(1,ObjectEffect,1)
      tObject=AddObject(1)
      ObjectSetShadow(tObject,2) : ` 2=Turn Culling off When Rendering Shadows
      SetObjectImage(1,50,3)
      LoadObject(2,"Resources\Map2.x")
      ApplyTexture(2,"Resources\")
      SetObjectEffect(2,ObjectEffect,1)
      tObject=AddObject(2)
      ObjectSetShadow(tObject,1)
      SetObjectImage(2,50,3)

   `Load Lights
      MapLoadEntities("Resources\Map.ent")

   `Dynamic object
      LoadTexture(10,"Resources\MetalTiles03.png")
      LoadTexture(11,"Resources\MetalTiles03_n.png")
      LoadTexture(12,"Resources\MetalTiles03_s.png")
      LoadObject(3,"Resources\knot.x"):SetObjectMeshUVScale(3,1,0,25,1)
      SetObjectEffect(3,ObjectEffect,1)
      tDynObject=AddObject(3)
      ObjectSetDynamic(tDynObject,1)
      ObjectSetShadow(tDynObject,1)
      SetObjectImage(3,10,0)
      SetObjectImage(3,11,1)
      SetObjectImage(3,12,2)
      SetObjectImage(3,50,3)
      SetObjectPosition(3,0,0,1250)
      SetObjectScale(3,0.70,0.70,0.70)

   `Skinned Mesh 
      LoadTexture(13,"Resources\Soldier_body_1_D.png")
      LoadTexture(14,"Resources\Soldier_body_1_D_n.png")
      LoadTexture(15,"Resources\Soldier_body_1_D_s.png")      
      LoadObjectWithChildren(4,"Resources\Original_Soldier.X")
      SetObjectScalePermanent(4,2,2,2)
      SetObjectEffect(4,SkinnedMeshEffect,1)
      tObject=AddObject(4)
      ObjectSetDynamic(tObject,1)
      ObjectSetShadow(tObject,1)
      ObjectSetDynamicUpdate(tObject,250)
      SetObjectImage(4,13,0)
      SetObjectImage(4,14,1)
      SetObjectImage(4,15,2)
      SetObjectImage(4,50,3)
      tChild=GetObjectChildID(4,1) : SetObjectVisible(tChild,0) 
      tChild=GetObjectChildID(4,2)
      SetObjectEffect(tChild,ObjectEffect,1) : `No bones
      tObject=AddObject(tChild)
      ObjectSetDynamic(tObject,1)
      ObjectSetShadow(tObject,1)
      SetObjectScalePermanent(tChild,2,2,2)
      SetObjectImage(tChild,13,0)
      SetObjectImage(tChild,14,1)
      SetObjectImage(tChild,15,2)
      SetObjectImage(tChild,50,3)
      PlayObjectAnimation(4,"",1000,1282,1,0)
      SetObjectAnimationSpeed(4,25)
      SetObjectPosition(4,50,-50,750)

   `Alpha object
      LoadTexture(16,"Resources\alpha.png")
      LoadTexture(17,"Resources\alpha_n.png")
      LoadTexture(18,"Resources\alpha_s.png")
      LoadObject(5,"Resources\ast4.X")
      SetObjectEffect(5,AlphaEffect,1)
      tAlphaObject=AddObject(5)
      ObjectSetAlpha(tAlphaObject,1)
      ObjectSetDynamic(tAlphaObject,1)
      SetObjectImage(5,16,0)
      SetObjectImage(5,17,1)
      SetObjectImage(5,18,2)
      SetObjectImage(5,50,3) 
      SetObjecttransparency(5,1) 
      SetObjectPosition(5,-580,240,2750)

   `Tree Object
      Set_Vector4(1,2500,750,250,5)
      SetEffectConstantVector(TreeEffect,"TreeWindSize",1)
      SetEffectConstantVector(LeafEffect,"TreeWindSize",1)
      Set_Vector4(1,10,5,1,0)
      SetEffectConstantVector(TreeEffect,"TreeWindPower",1)
      SetEffectConstantVector(LeafEffect,"TreeWindPower",1)
      LoadObject(6,"Resources\tree.x")
      ApplyTexture(6,"Resources\")
      SetobjectPosition(6,-180,-50,1400)
      Setobjectscale(6,0.7,0.7,0.7)
      LoadExtraTreeData("Resources\tree.dat",6,TreeEffect,LeafEffect)
      tObject=AddObject(6)
      ObjectSetShadow(tObject,1)
      SetObjectImage(6,50,3)

   `Lights
      LoadTexture(20,"Resources\point.png")
      LoadTexture(21,"Resources\spot.png")
      Light1=AddLight()
      LightSetTexture(Light1,20)
      Light2=AddLight()
      LightSetTexture(Light2,20)
      Light3=AddLight()
      LightSetTexture(Light3,21)

   `Start Timer
      TimerStart#=timer()

   `Start loop
      do

   `Timer
      ThisFrame#=timer()
      Difference#=ThisFrame#-LastFrame#
      LastFrame#=ThisFrame#
      TimeVal#=Difference#*60

   `Exit programme
      if GetRawKeyState(27)=1 then end

   `Control camera
      cr#=0:cf#=0
      if GetRawKeyState(65)=1 or GetRawKeyState(37)=1 then cr#=-4*TimeVal#
      if GetRawKeyState(68)=1 or GetRawKeyState(38)=1 then cr#=4*TimeVal#
      if GetRawKeyState(87)=1 or GetRawKeyState(39)=1 then cf#=4*TimeVal#
      if GetRawKeyState(83)=1 or GetRawKeyState(40)=1 then cf#=-4*TimeVal#
      if GetRawKeyState(16)=1 then cf#=cf#*2
      cx#=cx#+MouseMoveY()*0.15
      cy#=cy#+MouseMoveX()*0.15
      ncr#=curvevalue(cr#,ncr#,4.0/TimeVal#)
      ncf#=curvevalue(cf#,ncf#,4.0/TimeVal#)
      if cx#>88 then cx#=88
      if cx#<-88  then cx#=-88
      ncx#=curveangle(cx#,ncx#,1.0/TimeVal#)
      ncy#=curveangle(cy#,ncy#,1.0/TimeVal#)
      MoveCameraZ(MainCamera,ncf#)
      MoveCameraX(MainCamera,ncr#)
      RotateCamera(MainCamera,ncx#,ncy#,0)

   `Tree Wind Timer
      inc TreeWindGlobal#,0.4*TimeVal#
      TreeWindGlobal#=wrapvalue(TreeWindGlobal#)
      inc TreeWindForce#,1.0*TimeVal#
      TreeWindForce#=wrapvalue(TreeWindForce#)
      inc TreeWindVariant#,1.5*TimeVal#
      TreeWindVariant#=wrapvalue(TreeWindVariant#)
      inc TreeWindFlutter#,8*TimeVal#
      TreeWindFlutter#=wrapvalue(TreeWindFlutter#)
      set_vector4(1,TreeWindGlobal#/57.3,TreeWindForce#/57.3,TreeWindVariant#/57.3,TreeWindFlutter#/57.3)
      SetEffectConstantVector(TreeEffect,"TreeWindTimer",1)
      SetEffectConstantVector(LeafEffect,"TreeWindTimer",1)

   `Move Dynamic object
      if GetRawMouseRightState()=1
         SetObjectPosition(3,CameraPositionX(MainCamera)+CameraDirectionX(MainCamera)*100,CameraPositionY(MainCamera)+CameraDirectionY(MainCamera)*100,CameraPositionZ(MainCamera)+CameraDirectionZ(MainCamera)*100)
      endif

   `Rotate object
      if GetRawKeyPressed(82)=1
         if RotateObject=0 then RotateObject=1 else RotateObject=0
      endif
      if RotateObject=0 then SetObjectRotation(3,0,GetObjectAngleY(3)+0.5*TimeVal#,0)
      SetObjectRotation(5,0,GetObjectAngleY(5)+0.25*TimeVal#,0)

   `Change Object
      if GetRawKeyPressed(32)=1
         px#=GetObjectX(3) : py#=GetObjectY(3) : pz#=GetObjectZ(3)
         ax#=GetObjectAngleX(3) : ay#=GetObjectAngleY(3) : az#=GetObjectAngleZ(3)
         RemoveObject(tDynObject)
         DeleteObject(3)
         inc ChangeObject
         if ChangeObject>4 then ChangeObject=0
         if ChangeObject=0
            LoadObject(3,"Resources/knot.x"):SetObjectMeshUVScale(3,1,0,25,1)
         endif
         if ChangeObject=1
            LoadObject(3,"Resources/tpot.x"):SetObjectMeshUVScale(3,1,0,5,5)
         endif
         if ChangeObject=2
            LoadObject(3,"Resources/Torus.x"):SetObjectMeshUVScale(3,1,0,4,2)
         endif
         if ChangeObject=3
            CreateObjectsphere(3,75,25,25):SetObjectMeshUVScale(3,1,0,5,3)
         endif
         if ChangeObject=4
            CreateObjectBox(3,75,75,75):SetObjectMeshUVScale(3,1,0,2,2)
         endif
         SetObjectEffect(3,ObjectEffect,1)
         tDynObject=AddObject(3)
         ObjectSetDynamic(tDynObject,1)
         ObjectSetShadow(tDynObject,1)
         SetObjectImage(3,10,0)
         SetObjectImage(3,11,1)
         SetObjectImage(3,12,2)
         SetObjectImage(3,50,3)
         SetObjectPosition(3,px#,py#,pz#)
         SetObjectRotation(3,ax#,ay#,az#)
         SetObjectScale(3,0.70,0.70,0.70)
         ThisFrame#=timer()
         LastFrame#=ThisFrame#
      endif

   `Move Dynamic Lights
      LightSetVisible(Light1,0)
      LightSetVisible(Light2,0)
      LightSetVisible(Light3,0)
      ang#=wrapvalue(ang#+0.25*TimeVal#)
      if GetRawKeyPressed(49)=1 
         if LightActive1=0 then LightActive1=1 else LightActive1=0
      endif
      if GetRawKeyState(49)=1  
          lp1x#=CameraPositionX(MainCamera):lp1y#=CameraPositionY(MainCamera):lp1z#=CameraPositionZ(MainCamera)
      endif
      if LightActive1=1
         LightSetPosition(Light1,lp1x#+cos(ang#)*100,lp1y#+cos(ang#)*10,lp1z#+sin(ang#)*100)
         LightSetAngle(Light1,cos(ang#)*100,cos(ang#)*100,sin(ang#)*100,0,0)
         LightSetColor(Light1,255,0,0)
         LightSetVisible(Light1,1)
      endif
      if GetRawKeyPressed(50)=1 
         if LightActive2=0 then LightActive2=1 else LightActive2=0
      endif
      if GetRawKeyState(50)=1  
         lp2x#=CameraPositionX(MainCamera):lp2y#=CameraPositionY(MainCamera):lp2z#=CameraPositionZ(MainCamera)
      endif
      if LightActive2=1
         LightSetPosition(Light2,lp2x#+sin(ang#)*100,lp2y#+sin(ang#)*10,lp2z#+cos(ang#)*100)
         LightSetAngle(Light2,sin(ang#)*100,sin(ang#)*100,cos(ang#)*100,0,0)
         LightSetColor(Light2,0,255,0)
         LightSetVisible(Light2,1)
      endif
      if GetRawMouseLeftPressed()=1
         if LightActive3=0 then LightActive3=1 else LightActive3=0
      endif
      angX#=CurveAngle(ncx#,angX#,8.0/TimeVal#) : angY#=CurveAngle(ncy#,angY#,8.0/TimeVal#)
      if LightActive3=1
         LightSetPosition(Light3,CameraPositionX(MainCamera)-10,CameraPositionY(MainCamera)-10,CameraPositionZ(MainCamera)-10)
         LightSetAngle(Light3,angX#,angY#,0,16,10)
         LightSetVisible(Light3,1)
      endif
      if GetRawKeyState(17)=1 then SkySetSunAngle(-Lighting_CameraAngle.x,Lighting_CameraAngle.y+180,0)
      SkySetCloudCoverage(Sky_CloudsCoverage+mousemovez()*0.025)

   `Text
      CenterText(sw#/2,20,"Tiled Rendering")
      CenterText(sw#/2,50,"FPS "+str(ScreenFps(),0))
      CenterText(sw#/2,80,"Space - Change Object      R - Rotate Object    MouseClick 1 - Dynamic Spot      MouseClick 2 - Position Object      Key 1 - Dynamic Point(1)      Key 2 - Dynamic Point(2)")

   `Update
      MouseMoveReset()
      Update(0)

   `Lighting Update+Render
      LightingUpDate(TimeVal#)

   `End loop
      Render2DFront()
      Swap()
      DeleteAllText()
      loop

